/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.concurrent.Futures;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.http.BaseJettyTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.InputSuppliers;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.WriteTo;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.StreamingPayload;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BaseBlobIntegrationTest
extends BaseBlobStoreIntegrationTest {
    private InputSupplier<InputStream> oneHundredOneConstitutions;
    private byte[] oneHundredOneConstitutionsMD5;
    private static long oneHundredOneConstitutionsLength;
    protected static volatile Crypto crypto;

    @Override
    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        super.setUpResourcesOnThisThread(testContext);
        this.oneHundredOneConstitutions = BaseBlobIntegrationTest.getTestDataSupplier();
        this.oneHundredOneConstitutionsMD5 = CryptoStreams.md5(this.oneHundredOneConstitutions);
    }

    public static InputSupplier<InputStream> getTestDataSupplier() throws IOException {
        byte[] oneConstitution = ByteStreams.toByteArray((InputStream)new GZIPInputStream(BaseJettyTest.class.getResourceAsStream("/const.txt.gz")));
        InputSupplier constitutionSupplier = ByteStreams.newInputStreamSupplier((byte[])oneConstitution);
        InputSupplier temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{constitutionSupplier});
        for (int i = 0; i < 100; ++i) {
            temp = ByteStreams.join((InputSupplier[])new InputSupplier[]{temp, constitutionSupplier});
        }
        oneHundredOneConstitutionsLength = (long)oneConstitution.length * 101L;
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutFileParallel() throws InterruptedException, IOException {
        File payloadFile = File.createTempFile("testPutFileParallel", "png");
        Files.copy((InputSupplier)InputSuppliers.of((InputStream)((Object)((Object)this)).getClass().getResource("/testimg.png").openStream()), (File)payloadFile);
        payloadFile.deleteOnExit();
        FilePayload testPayload = Payloads.newFilePayload((File)payloadFile);
        byte[] md5 = CryptoStreams.md5((InputSupplier)testPayload);
        testPayload.getContentMetadata().setContentType("image/png");
        final AtomicInteger blobCount = new AtomicInteger();
        String container = this.getContainerName();
        try {
            HashMap responses = Maps.newHashMap();
            for (int i = 0; i < 10; ++i) {
                responses.put(i, this.exec.submit(new Callable<Void>((Payload)testPayload, container, md5){
                    final /* synthetic */ Payload val$testPayload;
                    final /* synthetic */ String val$container;
                    final /* synthetic */ byte[] val$md5;
                    {
                        this.val$testPayload = payload;
                        this.val$container = string;
                        this.val$md5 = byArray;
                    }

                    @Override
                    public Void call() throws Exception {
                        String name = blobCount.incrementAndGet() + "";
                        Blob blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().blobBuilder(name).payload(this.val$testPayload).build();
                        ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().putBlob(this.val$container, blob);
                        BaseBlobIntegrationTest.this.assertConsistencyAwareBlobExists(this.val$container, name);
                        blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().getBlob(this.val$container, name);
                        assert (Arrays.equals(CryptoStreams.md5((InputSupplier)blob.getPayload()), this.val$md5)) : String.format("md5 didn't match on %s/%s", this.val$container, name);
                        ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().removeBlob(this.val$container, name);
                        BaseBlobIntegrationTest.this.assertConsistencyAwareBlobDoesntExist(this.val$container, name);
                        return null;
                    }
                }));
            }
            Map exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.exec, (Long)30000L, (Logger)Logger.CONSOLE, (String)"putFileParallel");
            assert (exceptions.size() == 0) : exceptions;
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testBigFileGets() throws InterruptedException, IOException {
        String expectedContentDisposition = "attachment; filename=constit.txt";
        final String container = this.getContainerName();
        try {
            String name = "constitution.txt";
            this.uploadConstitution(container, "constitution.txt", "attachment; filename=constit.txt");
            HashMap responses = Maps.newHashMap();
            for (int i = 0; i < 10; ++i) {
                responses.put(i, Futures.compose((Future)((BlobStoreContext)this.view).getAsyncBlobStore().getBlob(container, "constitution.txt"), (Function)new Function<Blob, Void>(){

                    public Void apply(Blob from) {
                        try {
                            BaseBlobIntegrationTest.this.validateMetadata(from.getMetadata(), container, "constitution.txt");
                            Assert.assertEquals((byte[])CryptoStreams.md5((InputSupplier)from.getPayload()), (byte[])BaseBlobIntegrationTest.this.oneHundredOneConstitutionsMD5);
                            BaseBlobIntegrationTest.this.checkContentDisposition(from, "attachment; filename=constit.txt");
                        }
                        catch (IOException e) {
                            Throwables.propagate((Throwable)e);
                        }
                        return null;
                    }
                }, (ExecutorService)this.exec));
            }
            Map exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.exec, (Long)30000L, (Logger)Logger.CONSOLE, (String)"get constitution");
            assert (exceptions.size() == 0) : exceptions;
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void uploadConstitution(String container, String name, String contentDisposition) throws IOException {
        ((BlobStoreContext)this.view).getBlobStore().putBlob(container, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload((InputStream)this.oneHundredOneConstitutions.getInput()).contentType("text/plain").contentMD5(this.oneHundredOneConstitutionsMD5).contentLength(oneHundredOneConstitutionsLength).contentDisposition(contentDisposition).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfModifiedSince() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            Date before = new Date(System.currentTimeMillis() - 1000L);
            this.addObjectAndValidateContent(container, name);
            this.addObjectAndValidateContent(container, name);
            Date after = new Date(System.currentTimeMillis() + 1000L);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifModifiedSince((Date)before));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifModifiedSince((Date)after));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)304);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCreateBlobWithExpiry() throws InterruptedException {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            String blobName = "hello";
            Date expires = new Date(System.currentTimeMillis() / 1000L * 1000L + 60000L);
            blobStore.putBlob(container, blobStore.blobBuilder("hello").payload(TEST_STRING).expires(expires).build());
            this.assertConsistencyAwareBlobExpiryMetadata(container, "hello", expires);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfUnmodifiedSince() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            Date before = new Date(System.currentTimeMillis() - 1000L);
            this.addObjectAndValidateContent(container, name);
            Date after = new Date(System.currentTimeMillis() + 1000L);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifUnmodifiedSince((Date)after));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifUnmodifiedSince((Date)before));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfMatch() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            String goodETag = this.addObjectAndValidateContent(container, name);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagMatches((String)goodETag));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagMatches((String)"powerfrisbee"));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfNoneMatch() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            String goodETag = this.addObjectAndValidateContent(container, name);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagDoesntMatch((String)"powerfrisbee"));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagDoesntMatch((String)goodETag));
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)304);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetRange() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            Blob blob1 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L));
            this.validateMetadata(blob1.getMetadata(), container, name);
            Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob1), (String)TEST_STRING.substring(0, 6));
            Blob blob2 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)6L, (long)TEST_STRING.length()));
            this.validateMetadata(blob2.getMetadata(), container, name);
            Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob2), (String)TEST_STRING.substring(6, TEST_STRING.length()));
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetTwoRanges() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L).range(6L, (long)TEST_STRING.length()));
            this.validateMetadata(blob.getMetadata(), container, name);
            Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob), (String)TEST_STRING);
        }
        finally {
            this.returnContainer(container);
        }
    }

    private String addObjectAndValidateContent(String sourcecontainer, String sourceKey) throws InterruptedException {
        String eTag = this.addBlobToContainer(sourcecontainer, sourceKey);
        this.validateContent(sourcecontainer, sourceKey);
        return eTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void deleteObjectNotFound() throws InterruptedException {
        String container = this.getContainerName();
        String name = "test";
        try {
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void blobNotFound() throws InterruptedException {
        String container = this.getContainerName();
        String name = "test";
        try {
            assert (!((BlobStoreContext)this.view).getBlobStore().blobExists(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"quote\""}, {"{great<r}"}, {"lesst>en"}, {"p|pe"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"}, dataProvider="delete")
    public void deleteObject(String name) throws InterruptedException {
        String container = this.getContainerName();
        try {
            this.addBlobToContainer(container, name, name, "text/plain");
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
            this.assertContainerEmptyDeleting(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void assertContainerEmptyDeleting(String container, String name) {
        Iterable listing = Iterables.filter((Iterable)((BlobStoreContext)this.view).getBlobStore().list(container), (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        });
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)0, (String)String.format("deleting %s, we still have %s blobs left in container %s, using encoding %s", name, Iterables.size((Iterable)listing), container, LOCAL_ENCODING));
    }

    @Test(groups={"integration", "live"})
    public void deleteObjectNoContainer() {
        try {
            ((BlobStoreContext)this.view).getBlobStore().removeBlob("donb", "test");
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)404);
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
    }

    @DataProvider(name="putTests")
    public Object[][] createData1() throws IOException {
        String realObject = Strings2.toStringAndClose((InputStream)new FileInputStream("pom.xml"));
        return new Object[][]{{"file", "text/xml", new File("pom.xml"), realObject}, {"string", "text/xml", realObject, realObject}, {"bytes", "application/octet-stream", realObject.getBytes(), realObject}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"}, dataProvider="putTests")
    public void testPutObject(String name, String type, Object content, Object realObject) throws InterruptedException, IOException {
        BlobBuilder.PayloadBlobBuilder blobBuilder = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(Payloads.newPayload((Object)content)).contentType(type);
        this.addContentMetadata(blobBuilder);
        if (content instanceof InputStream) {
            blobBuilder.calculateMD5();
        }
        Blob blob = blobBuilder.build();
        String container = this.getContainerName();
        try {
            Assert.assertNotNull((Object)((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob));
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, blob.getMetadata().getName());
            this.validateMetadata(blob.getMetadata(), container, name);
            this.checkContentMetadata(blob);
            String returnedString = BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob);
            Assert.assertEquals((Object)returnedString, (Object)realObject);
            PageSet set = ((BlobStoreContext)this.view).getBlobStore().list(container);
            assert (set.size() == 1) : set;
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutObjectStream() throws InterruptedException, IOException, ExecutionException {
        BlobBuilder.PayloadBlobBuilder blobBuilder = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("streaming").payload((Payload)new StreamingPayload(new WriteTo(){

            public void writeTo(OutputStream outstream) throws IOException {
                outstream.write("foo".getBytes());
            }
        }));
        this.addContentMetadata(blobBuilder);
        Blob blob = blobBuilder.build();
        String container = this.getContainerName();
        try {
            Assert.assertNotNull((Object)((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob));
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, blob.getMetadata().getName());
            String returnedString = BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob);
            Assert.assertEquals((String)returnedString, (String)"foo");
            this.validateMetadata(blob.getMetadata(), container, blob.getMetadata().getName());
            this.checkContentMetadata(blob);
            PageSet set = ((BlobStoreContext)this.view).getBlobStore().list(container);
            assert (set.size() == 1) : set;
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void checkContentMetadata(Blob blob) {
        this.checkContentType(blob, "text/csv");
        this.checkContentDisposition(blob, "attachment; filename=photo.jpg");
        this.checkContentEncoding(blob, "gzip");
        this.checkContentLanguage(blob, "en");
    }

    private void addContentMetadata(BlobBuilder.PayloadBlobBuilder blobBuilder) {
        blobBuilder.contentType("text/csv");
        blobBuilder.contentDisposition("attachment; filename=photo.jpg");
        blobBuilder.contentEncoding("gzip");
        blobBuilder.contentLanguage("en");
    }

    protected void checkContentType(Blob blob, String contentType) {
        assert (blob.getPayload().getContentMetadata().getContentType().startsWith(contentType)) : blob.getPayload().getContentMetadata().getContentType();
        assert (blob.getMetadata().getContentMetadata().getContentType().startsWith(contentType)) : blob.getMetadata().getContentMetadata().getContentType();
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        assert (blob.getPayload().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getPayload().getContentMetadata().getContentDisposition();
        assert (blob.getMetadata().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getMetadata().getContentMetadata().getContentDisposition();
    }

    protected void checkContentEncoding(Blob blob, String contentEncoding) {
        assert (blob.getPayload().getContentMetadata().getContentEncoding().indexOf(contentEncoding) != -1) : blob.getPayload().getContentMetadata().getContentEncoding();
        assert (blob.getMetadata().getContentMetadata().getContentEncoding().indexOf(contentEncoding) != -1) : blob.getMetadata().getContentMetadata().getContentEncoding();
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage().startsWith(contentLanguage)) : blob.getPayload().getContentMetadata().getContentLanguage();
        assert (blob.getMetadata().getContentMetadata().getContentLanguage().startsWith(contentLanguage)) : blob.getMetadata().getContentMetadata().getContentLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMetadata() throws InterruptedException, IOException {
        String name = "hello";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").calculateMD5().build();
        String container = this.getContainerName();
        try {
            Assert.assertNull((Object)((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, "powderpuff"));
            this.addBlobToContainer(container, blob);
            Blob newObject = this.validateContent(container, name);
            MutableBlobMetadata metadata = newObject.getMetadata();
            this.validateMetadata((BlobMetadata)metadata);
            this.validateMetadata(metadata, container, name);
            this.validateMetadata(((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name));
            blob.getMetadata().getUserMetadata().put("Adrian", "wonderpuff");
            blob.getMetadata().getUserMetadata().put("Adrian", "powderpuff");
            this.addBlobToContainer(container, blob);
            this.validateMetadata(((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected void validateMetadata(BlobMetadata metadata) throws IOException {
        assert (metadata.getContentMetadata().getContentType().startsWith("text/plain")) : metadata.getContentMetadata().getContentType();
        Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)new Long(TEST_STRING.length()));
        Assert.assertEquals((String)((String)metadata.getUserMetadata().get("adrian")), (String)"powderpuff");
        this.checkMD5(metadata);
    }

    protected void checkMD5(BlobMetadata metadata) throws IOException {
        Assert.assertEquals((byte[])metadata.getContentMetadata().getContentMD5(), (byte[])CryptoStreams.md5((InputSupplier)InputSuppliers.of((String)TEST_STRING)));
    }

    static {
        try {
            crypto = new JCECrypto();
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

