/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Preconditions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseBlobLiveTest
extends BaseBlobStoreIntegrationTest {
    private static final String sysHttpStreamUrl = System.getProperty("jclouds.blobstore.httpstream.url");
    private static final String sysHttpStreamMD5 = System.getProperty("jclouds.blobstore.httpstream.md5");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Parameters(value={"jclouds.blobstore.httpstream.url", "jclouds.blobstore.httpstream.md5"})
    public void testCopyUrl(@Optional String httpStreamUrl, @Optional String httpStreamMD5) throws Exception {
        httpStreamUrl = (String)Preconditions.checkNotNull((Object)(httpStreamUrl != null ? httpStreamUrl : sysHttpStreamUrl), (Object)"httpStreamUrl");
        httpStreamMD5 = (String)Preconditions.checkNotNull((Object)(httpStreamMD5 != null ? httpStreamMD5 : sysHttpStreamMD5), (Object)"httpStreamMd5");
        HttpResponse response = ((BlobStoreContext)this.view).utils().http().invoke(HttpRequest.builder().method("GET").endpoint(httpStreamUrl).build());
        long length = response.getPayload().getContentMetadata().getContentLength();
        String name = "hello";
        byte[] md5 = CryptoStreams.hex((String)httpStreamMD5);
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(response.getPayload()).contentLength(length).contentMD5(md5).build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.checkMD5(container, name, md5);
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected void checkMD5(String container, String name, byte[] md5) {
        Assert.assertEquals((byte[])((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name).getContentMetadata().getContentMD5(), (byte[])md5);
    }
}

