/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseMapIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseBlobMapIntegrationTest
extends BaseMapIntegrationTest<Blob> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testValues() throws IOException, InterruptedException {
        String bucketName = this.getContainerName();
        try {
            BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            this.putFiveStrings(map);
            this.putFiveStringsUnderPath(map);
            Collection blobs = map.values();
            this.assertConsistencyAwareMapSize(map, 5);
            LinkedHashSet blobsAsString = Sets.newLinkedHashSet();
            for (Blob blob : blobs) {
                blobsAsString.add(BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob));
            }
            blobsAsString.removeAll(this.fiveStrings.values());
            assert (blobsAsString.size() == 0) : blobsAsString.size() + ": " + blobs + ": " + blobsAsString;
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testRemove() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String bucketName = this.getContainerName();
        try {
            BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            this.putStringWithMD5((Map<String, Blob>)map, "one", "two");
            this.assertConsistencyAwareContentEquals((Map<String, Blob>)map, "one", "two");
            this.assertConsistencyAwareRemoveEquals(map, "one", (Object)null);
            this.assertConsistencyAwareGetEquals(map, "one", (Object)null);
            this.assertConsistencyAwareKeySize(map, 0);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    private void assertConsistencyAwareContentEquals(final Map<String, Blob> map, final String key, final String blob) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                Blob old = (Blob)map.remove(key);
                try {
                    Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)old), (String)blob);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testEntrySet() throws IOException, InterruptedException {
        String bucketName = this.getContainerName();
        try {
            final BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            this.putFiveStrings(map);
            this.assertConsistencyAwareMapSize(map, 5);
            Set entries = map.entrySet();
            Assert.assertEquals((int)entries.size(), (int)5);
            for (Map.Entry entry : entries) {
                Assert.assertEquals((String)((String)this.fiveStrings.get(entry.getKey())), (String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)((Blob)entry.getValue())));
                Blob blob = (Blob)entry.getValue();
                blob.setPayload("");
                Payloads.calculateMD5((PayloadEnclosing)blob);
                entry.setValue(blob);
            }
            this.assertConsistencyAware(new Runnable(){

                @Override
                public void run() {
                    for (Blob blob : map.values()) {
                        try {
                            Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)blob), (String)"");
                        }
                        catch (IOException e) {
                            Throwables.propagate((Throwable)e);
                        }
                    }
                }
            });
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testContains() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String bucketName = this.getContainerName();
        try {
            BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            this.putStringWithMD5((Map<String, Blob>)map, "one", "apple");
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("one").payload("apple").calculateMD5().build();
            this.assertConsistencyAwareContainsValue(map, blob);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    void getOneReturnsAppleAndOldValueIsNull(Map<String, Blob> map, Blob old) throws IOException, InterruptedException {
        assert (old == null);
        Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)map.get("one")), (String)"apple");
        this.assertConsistencyAwareMapSize(map, 1);
    }

    void getOneReturnsBearAndOldValueIsApple(Map<String, Blob> map, Blob oldValue) throws IOException, InterruptedException {
        Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)((Blob)Preconditions.checkNotNull((Object)map.get("one"), (Object)"one"))), (String)"bear");
        Assert.assertEquals((String)BlobStoreUtils.getContentAsStringOrNullAndClose((Blob)oldValue), (String)"apple");
        this.assertConsistencyAwareMapSize(map, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testPut() throws IOException, InterruptedException {
        String bucketName = this.getContainerName();
        try {
            BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("one").payload(Strings2.toInputStream((String)"apple")).calculateMD5().build();
            Blob old = map.put(blob.getMetadata().getName(), blob);
            this.getOneReturnsAppleAndOldValueIsNull((Map<String, Blob>)map, old);
            blob.setPayload(Strings2.toInputStream((String)"bear"));
            Payloads.calculateMD5((PayloadEnclosing)blob);
            Blob apple = map.put(blob.getMetadata().getName(), blob);
            this.getOneReturnsBearAndOldValueIsApple((Map<String, Blob>)map, apple);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test(groups={"integration", "live"})
    public void testPutAll() throws InterruptedException, ExecutionException, TimeoutException {
        String bucketName = this.getContainerName();
        try {
            BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            ImmutableMap.Builder newMap = ImmutableMap.builder();
            for (String key : this.fiveInputs.keySet()) {
                newMap.put((Object)key, (Object)((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).payload((InputStream)this.fiveInputs.get(key)).contentLength((long)((byte[])this.fiveBytes.get(key)).length).build());
            }
            map.putAll(newMap.build());
            this.assertConsistencyAwareMapSize(map, 5);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)ImmutableSet.copyOf(this.fiveInputs.keySet()));
            this.fourLeftRemovingOne(map);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutMoreThanSingleListing() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.maxResultsForTestListings() == 0) {
            return;
        }
        String bucketName = this.getContainerName();
        try {
            BlobMap map = this.createMap((BlobStoreContext)this.view, bucketName);
            ImmutableSet.Builder keySet = ImmutableSet.builder();
            for (int i = 0; i < this.maxResultsForTestListings() + 1; ++i) {
                keySet.add((Object)(i + ""));
            }
            LinkedHashMap newMap = Maps.newLinkedHashMap();
            for (String key : keySet.build()) {
                newMap.put(key, map.blobBuilder().payload(key).build());
            }
            map.putAll((Map)newMap);
            newMap.clear();
            this.assertConsistencyAwareMapSize(map, this.maxResultsForTestListings() + 1);
            this.assertConsistencyAwareKeySetEquals(map, (Set<String>)keySet.build());
            map.clear();
            this.assertConsistencyAwareMapSize(map, 0);
        }
        finally {
            this.returnContainer(bucketName);
        }
    }

    @Override
    protected void putStringWithMD5(Map<String, Blob> map, String key, String text) throws IOException {
        map.put(key, ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).payload(text).calculateMD5().build());
    }

    protected void putFiveStrings(BlobMap map) {
        map.putAll(Maps.transformValues((Map)this.fiveStrings, (Function)new StringToBlob(map)));
    }

    protected void putFiveStringsUnderPath(BlobMap map) {
        map.putAll(Maps.transformValues((Map)this.fiveStringsUnderPath, (Function)new StringToBlob(map)));
    }

    protected int maxResultsForTestListings() {
        return 100;
    }

    protected BlobMap createMap(BlobStoreContext context, String bucket) {
        return this.createMap(context, bucket, ListContainerOptions.Builder.maxResults((int)this.maxResultsForTestListings()));
    }

    protected BlobMap createMap(BlobStoreContext context, String bucket, ListContainerOptions options) {
        return context.createBlobMap(bucket, options);
    }

    @Override
    protected void addTenObjectsUnderPrefix(String containerName, String prefix) throws InterruptedException {
        BlobMap blobMap = this.createMap((BlobStoreContext)this.view, containerName, ListContainerOptions.Builder.inDirectory((String)prefix));
        for (int i = 0; i < 10; ++i) {
            blobMap.put((Object)(i + ""), (Object)blobMap.blobBuilder().payload(i + "content").build());
        }
    }

    @Override
    protected void addTenObjectsUnderRoot(String containerName) throws InterruptedException {
        BlobMap blobMap = this.createMap((BlobStoreContext)this.view, containerName, (ListContainerOptions)ListContainerOptions.NONE);
        for (int i = 0; i < 10; ++i) {
            blobMap.put((Object)(i + ""), (Object)blobMap.blobBuilder().payload(i + "content").build());
        }
    }

    private static class StringToBlob
    implements Function<String, Blob> {
        private final BlobMap map;

        private StringToBlob(BlobMap map) {
            this.map = map;
        }

        public Blob apply(String arg0) {
            return this.map.blobBuilder().payload(arg0).build();
        }
    }
}

