/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.easymock.EasyMock;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.rest.Providers;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BlobStoreUtilsTest {
    @Test
    public void testSupportedBlobStoreProviders() {
        Iterable providers = BlobStoreUtils.getSupportedProviders();
        assert (Iterables.contains((Iterable)providers, (Object)"transient")) : providers;
    }

    @Test
    public void testSupportedProviders() {
        Iterable providers = Providers.getSupportedProviders();
        assert (Iterables.contains((Iterable)providers, (Object)"transient")) : providers;
    }

    public void testCreateParentIfNeededAsyncNoPath() {
        AsyncBlobStore asyncBlobStore = (AsyncBlobStore)EasyMock.createMock(AsyncBlobStore.class);
        String container = "container";
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        MutableBlobMetadata md = (MutableBlobMetadata)EasyMock.createMock(MutableBlobMetadata.class);
        EasyMock.expect((Object)blob.getMetadata()).andReturn((Object)md).atLeastOnce();
        EasyMock.expect((Object)md.getName()).andReturn((Object)"hello").atLeastOnce();
        EasyMock.replay((Object[])new Object[]{asyncBlobStore});
        EasyMock.replay((Object[])new Object[]{blob});
        EasyMock.replay((Object[])new Object[]{md});
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)asyncBlobStore, (String)container, (Blob)blob);
        EasyMock.verify((Object[])new Object[]{asyncBlobStore});
        EasyMock.verify((Object[])new Object[]{blob});
        EasyMock.verify((Object[])new Object[]{md});
    }

    public void testCreateParentIfNeededAsyncSinglePath() {
        AsyncBlobStore asyncBlobStore = (AsyncBlobStore)EasyMock.createMock(AsyncBlobStore.class);
        String container = "container";
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        MutableBlobMetadata md = (MutableBlobMetadata)EasyMock.createMock(MutableBlobMetadata.class);
        EasyMock.expect((Object)blob.getMetadata()).andReturn((Object)md).atLeastOnce();
        EasyMock.expect((Object)md.getName()).andReturn((Object)"rootpath/hello").atLeastOnce();
        EasyMock.expect((Object)asyncBlobStore.createDirectory("container", "rootpath")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{asyncBlobStore});
        EasyMock.replay((Object[])new Object[]{blob});
        EasyMock.replay((Object[])new Object[]{md});
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)asyncBlobStore, (String)container, (Blob)blob);
        EasyMock.verify((Object[])new Object[]{asyncBlobStore});
        EasyMock.verify((Object[])new Object[]{blob});
        EasyMock.verify((Object[])new Object[]{md});
    }

    public void testCreateParentIfNeededAsyncNestedPath() {
        AsyncBlobStore asyncBlobStore = (AsyncBlobStore)EasyMock.createMock(AsyncBlobStore.class);
        String container = "container";
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        MutableBlobMetadata md = (MutableBlobMetadata)EasyMock.createMock(MutableBlobMetadata.class);
        EasyMock.expect((Object)blob.getMetadata()).andReturn((Object)md).atLeastOnce();
        EasyMock.expect((Object)md.getName()).andReturn((Object)"rootpath/subpath/hello").atLeastOnce();
        EasyMock.expect((Object)asyncBlobStore.createDirectory("container", "rootpath/subpath")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{asyncBlobStore});
        EasyMock.replay((Object[])new Object[]{blob});
        EasyMock.replay((Object[])new Object[]{md});
        BlobStoreUtils.createParentIfNeededAsync((AsyncBlobStore)asyncBlobStore, (String)container, (Blob)blob);
        EasyMock.verify((Object[])new Object[]{asyncBlobStore});
        EasyMock.verify((Object[])new Object[]{blob});
        EasyMock.verify((Object[])new Object[]{md});
    }

    public void testGetKeyForAzureS3AndRackspace() {
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("https://jclouds.blob.core.windows.net/adriancole-blobstore0/five"));
        EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)"adriancole-blobstore0", (Object)"five")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{request});
        Assert.assertEquals((String)BlobStoreUtils.getNameFor((GeneratedHttpRequest)request), (String)"five");
    }

    public void testGetKeyForAtmos() {
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("https://storage4.clouddrive.com/v1/MossoCloudFS_dc1f419c-5059-4c87-a389-3f2e33a77b22/adriancole-blobstore0/four"));
        EasyMock.expect((Object)request.getArgs()).andReturn((Object)ImmutableList.of((Object)"adriancole-blobstore0/four")).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{request});
        Assert.assertEquals((String)BlobStoreUtils.getNameFor((GeneratedHttpRequest)request), (String)"four");
    }

    public void testGetContainer() {
        String container = BlobStoreUtils.parseContainerFromPath((String)"foo");
        Assert.assertEquals((String)container, (String)"foo");
        container = BlobStoreUtils.parseContainerFromPath((String)"foo/");
        Assert.assertEquals((String)container, (String)"foo");
        container = BlobStoreUtils.parseContainerFromPath((String)"foo/bar");
        Assert.assertEquals((String)container, (String)"foo");
    }

    public void testGetPrefix() {
        String prefix = BlobStoreUtils.parsePrefixFromPath((String)"foo");
        Assert.assertEquals((String)prefix, null);
        prefix = BlobStoreUtils.parsePrefixFromPath((String)"foo/");
        Assert.assertEquals((String)prefix, null);
        prefix = BlobStoreUtils.parsePrefixFromPath((String)"foo/bar");
        Assert.assertEquals((String)prefix, (String)"bar");
    }
}

