/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.PrettyJSON;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.test.GraphDescription;

public class BatchOperationDocIT
extends AbstractRestFunctionalTestBase {
    @Documented(value=" Execute multiple operations in batch.\n \n This lets you execute multiple API calls through a single HTTP call,\n significantly improving performance for large insert and update\n operations.\n \n The batch service expects an array of job descriptions as input, each job\n description describing an action to be performed via the normal server\n API.\n \n This service is transactional. If any of the operations performed fails\n (returns a non-2xx HTTP status code), the transaction will be rolled back\n and all changes will be undone.\n \n Each job description should contain a +to+ attribute, with a value\n relative to the data API root (so http://localhost:7474/db/data/node becomes\n just /node), and a +method+ attribute containing HTTP verb to use.\n \n Optionally you may provide a +body+ attribute, and an +id+ attribute to\n help you keep track of responses, although responses are guaranteed to be\n returned in the same order the job descriptions are received.\n \n The following figure outlines the different parts of the job\n descriptions:\n \n image::batch-request-api.png[]\n")
    @Test
    @GraphDescription.Graph(value={"Joe knows John"})
    public void shouldPerformMultipleOperations() throws Exception {
        long idJoe = ((Node)((Map)this.data.get()).get("Joe")).getId();
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"PUT").key("to").value((Object)("/node/" + idJoe + "/properties")).key("body").object().key("age").value(1L).endObject().key("id").value(0L).endObject().object().key("method").value((Object)"GET").key("to").value((Object)("/node/" + idJoe)).key("id").value(1L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().key("id").value(2L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().key("id").value(3L).endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).payload(jsonString).expectedStatus(200).post(this.batchUri()).entity();
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)4L, (long)results.size());
        Map putResult = (Map)results.get(0);
        Map getResult = (Map)results.get(1);
        Map firstPostResult = (Map)results.get(2);
        Map secondPostResult = (Map)results.get(3);
        Assert.assertEquals((Object)0, putResult.get("id"));
        Assert.assertEquals((Object)2, firstPostResult.get("id"));
        Assert.assertEquals((Object)3, secondPostResult.get("id"));
        Assert.assertEquals((Object)("/node/" + idJoe + "/properties"), putResult.get("from"));
        Assert.assertEquals((Object)("/node/" + idJoe), getResult.get("from"));
        Assert.assertEquals((Object)"/node", firstPostResult.get("from"));
        Assert.assertEquals((Object)"/node", secondPostResult.get("from"));
        Assert.assertTrue((((String)firstPostResult.get("location")).length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((String)secondPostResult.get("location")).length() > 0 ? 1 : 0) != 0);
        Map body = (Map)getResult.get("body");
        Assert.assertEquals((Object)1, ((Map)body.get("data")).get("age"));
    }

    @Documented(value=" Refer to items created earlier in the same batch job.\n \n The batch operation API allows you to refer to the URI returned from a\n created resource in subsequent job descriptions, within the same batch\n call.\n \n Use the +{[JOB ID]}+ special syntax to inject URIs from created resources\n into JSON strings in subsequent job descriptions.\n")
    @Test
    public void shouldBeAbleToReferToCreatedResource() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("id").value(0L).key("body").object().key("name").value((Object)"bob").endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("id").value(1L).key("body").object().key("age").value(12L).endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"{0}/relationships").key("id").value(3L).key("body").object().key("to").value((Object)"{1}").key("data").object().key("since").value((Object)"2010").endObject().key("type").value((Object)"KNOWS").endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels").key("id").value(4L).key("body").object().key("key").value((Object)"since").key("value").value((Object)"2010").key("uri").value((Object)"{3}").endObject().endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)4L, (long)results.size());
    }

    private String batchUri() {
        return this.getDataUri() + "batch";
    }

    @Test
    public void shouldGetLocationHeadersWhenCreatingThings() throws Exception {
        int originalNodeCount = this.countNodes();
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().endObject().endArray().toString();
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)(originalNodeCount + 1), (long)this.countNodes());
        List results = JsonHelper.jsonToList((String)response.getEntity());
        Assert.assertEquals((long)1L, (long)results.size());
        Map result = (Map)results.get(0);
        Assert.assertTrue((((String)result.get("location")).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldForwardUnderlyingErrors() throws Exception {
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").array().value(true).value((Object)"hello").endArray().endObject().endObject().endArray().toString());
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Map res = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertTrue((boolean)((String)res.get("message")).startsWith("Invalid JSON array in POST body"));
    }

    @Test
    public void shouldRollbackAllWhenGivenIncorrectRequest() throws JsonParseException, ClientHandlerException, UniformInterfaceException, JSONException {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value((Object)"1").endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").array().value((Object)"a_list").value((Object)"this_makes_no_sense").endArray().endObject().endArray().toString();
        int originalNodeCount = this.countNodes();
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), jsonString);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((long)originalNodeCount, (long)this.countNodes());
    }

    @Test
    public void shouldHandleUnicodeGetCorrectly() throws Exception {
        String asianText = "\u4f8b\u5b50";
        String germanText = "\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\u00df";
        String complicatedString = asianText + germanText;
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key(complicatedString).value((Object)complicatedString).endObject().endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        Map response = (Map)((Map)JsonHelper.jsonToList((String)entity).get(0)).get("body");
        String returnedValue = (String)((Map)response.get("data")).get(complicatedString);
        Assert.assertThat((String)("Expected twisted unicode case to work, but response was: " + entity), (Object)returnedValue, (Matcher)Matchers.is((Object)complicatedString));
    }

    @Test
    public void shouldHandleFailingCypherStatementCorrectly() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/cypher").key("body").object().key("query").value((Object)"start n=node({id}) set n.foo = 10   return n").key("params").object().key("id").value((Object)"0").endObject().endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(500).payload(jsonString).post(this.batchUri()).entity();
        Map result = JsonHelper.jsonToMap((String)entity);
        String exception = (String)result.get("exception");
        Assert.assertThat((Object)exception, (Matcher)Matchers.is((Object)"BatchOperationFailedException"));
        String innerException = (String)JsonHelper.jsonToMap((String)((String)result.get("message"))).get("exception");
        Assert.assertThat((Object)innerException, (Matcher)Matchers.is((Object)"ParameterWrongTypeException"));
    }

    @Test
    @GraphDescription.Graph(value={"Peter likes Jazz"})
    public void shouldHandleEscapedStrings() throws ClientHandlerException, UniformInterfaceException, JSONException, PropertyValueException {
        String string = "Jazz";
        Node gnode = this.getNode(string);
        Assert.assertEquals((Object)gnode.getProperty("name"), (Object)string);
        String name = "string\\ and \"test\"";
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"PUT").key("to").value((Object)("/node/" + gnode.getId() + "/properties")).key("body").object().key("name").value((Object)name).endObject().endObject().endArray().toString();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        jsonString = new PrettyJSON().array().object().key("method").value((Object)"GET").key("to").value((Object)("/node/" + gnode.getId() + "/properties/name")).endObject().endArray().toString();
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).payload(jsonString).post(this.batchUri()).entity();
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals(((Map)results.get(0)).get("body"), (Object)name);
    }

    @Test
    public void shouldRollbackAllWhenInsertingIllegalData() throws JsonParseException, ClientHandlerException, UniformInterfaceException, JSONException {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").object().key("age").value(1L).endObject().endObject().endObject().endArray().toString();
        int originalNodeCount = this.countNodes();
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), jsonString);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((long)originalNodeCount, (long)this.countNodes());
    }

    @Test
    public void shouldRollbackAllOnSingle404() throws JsonParseException, ClientHandlerException, UniformInterfaceException, JSONException {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("body").object().key("age").value(1L).endObject().endObject().object().key("method").value((Object)"POST").key("to").value((Object)"www.google.com").endObject().endArray().toString();
        int originalNodeCount = this.countNodes();
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), jsonString);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((long)originalNodeCount, (long)this.countNodes());
    }

    @Test
    public void shouldBeAbleToReferToUniquelyCreatedEntities() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"ID").key("value").value((Object)"fra").key("properties").object().key("ID").value((Object)"fra").endObject().endObject().key("id").value(0L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/node").key("id").value(1L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"{1}/relationships").key("body").object().key("to").value((Object)"{0}").key("type").value((Object)"has").endObject().key("id").value(2L).endObject().endArray().toString();
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToReferToNotCreatedUniqueEntities() throws Exception {
        String jsonString = new PrettyJSON().array().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"tobias").key("properties").object().key("name").value((Object)"Tobias Tester").endObject().endObject().key("id").value(0L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres").key("properties").object().key("name").value((Object)"Andres Tester").endObject().endObject().key("id").value(1L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/node/Cultures?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres").key("properties").object().key("name").value((Object)"Andres Tester").endObject().endObject().key("id").value(2L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels/?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"tobias-andres").key("start").value((Object)"{0}").key("end").value((Object)"{1}").key("type").value((Object)"FRIENDS").endObject().key("id").value(3L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels/?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres-tobias").key("start").value((Object)"{2}").key("end").value((Object)"{0}").key("type").value((Object)"FRIENDS").endObject().key("id").value(4L).endObject().object().key("method").value((Object)"POST").key("to").value((Object)"/index/relationship/my_rels/?unique").key("body").object().key("key").value((Object)"name").key("value").value((Object)"andres-tobias").key("start").value((Object)"{1}").key("end").value((Object)"{0}").key("type").value((Object)"FRIENDS").endObject().key("id").value(5L).endObject().endArray().toString();
        JaxRsResponse response = RestRequest.req().post(this.batchUri(), jsonString);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = response.getEntity();
        List results = JsonHelper.jsonToList((String)entity);
        Assert.assertEquals((long)6L, (long)results.size());
        Map andresResult1 = (Map)results.get(1);
        Map andresResult2 = (Map)results.get(2);
        Map secondRelationship = (Map)results.get(4);
        Map thirdRelationship = (Map)results.get(5);
        Map body1 = (Map)andresResult1.get("body");
        Map body2 = (Map)andresResult2.get("body");
        Assert.assertEquals(body1.get("id"), body2.get("id"));
        body1 = (Map)secondRelationship.get("body");
        body2 = (Map)thirdRelationship.get("body");
        Assert.assertEquals(body1.get("self"), body2.get("self"));
        Assert.assertTrue((((String)secondRelationship.get("location")).length() > 0 ? 1 : 0) != 0);
        body1 = (Map)secondRelationship.get("body");
        body2 = (Map)andresResult1.get("body");
        Assert.assertEquals(body1.get("start"), body2.get("self"));
    }

    private int countNodes() {
        int count = 0;
        for (Node node : this.graphdb().getAllNodes()) {
            ++count;
        }
        return count;
    }
}

