/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.Client;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;

public class DiscoveryServiceDocIT
extends AbstractRestFunctionalTestBase {
    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
    }

    @Test
    public void shouldRespondWith200WhenRetrievingDiscoveryDocument() throws Exception {
        JaxRsResponse response = this.getDiscoveryDocument();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGetContentLengthHeaderWhenRetrievingDiscoveryDocument() throws Exception {
        JaxRsResponse response = this.getDiscoveryDocument();
        Assert.assertNotNull((Object)response.getHeaders().get((Object)"Content-Length"));
        response.close();
    }

    @Test
    public void shouldHaveJsonMediaTypeWhenRetrievingDiscoveryDocument() throws Exception {
        JaxRsResponse response = this.getDiscoveryDocument();
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        response.close();
    }

    @Test
    public void shouldHaveJsonDataInResponse() throws Exception {
        JaxRsResponse response = this.getDiscoveryDocument();
        Map map = JsonHelper.jsonToMap((String)response.getEntity());
        String managementKey = "management";
        Assert.assertTrue((boolean)map.containsKey(managementKey));
        Assert.assertNotNull(map.get(managementKey));
        String dataKey = "data";
        Assert.assertTrue((boolean)map.containsKey(dataKey));
        Assert.assertNotNull(map.get(dataKey));
        response.close();
    }

    @Test
    public void shouldRedirectToWebadminOnHtmlRequest() throws Exception {
        Client nonRedirectingClient = Client.create();
        nonRedirectingClient.setFollowRedirects(Boolean.valueOf(false));
        JaxRsResponse clientResponse = new RestRequest(null, nonRedirectingClient).get(DiscoveryServiceDocIT.server().baseUri().toString(), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)303L, (long)clientResponse.getStatus());
    }

    private JaxRsResponse getDiscoveryDocument() throws Exception {
        return new RestRequest(DiscoveryServiceDocIT.server().baseUri()).get();
    }
}

