/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.util.RFC1123;
import org.neo4j.server.rest.transactional.error.StatusCode;
import org.neo4j.test.server.HTTP;
import org.neo4j.tooling.GlobalGraphOperations;

public class TransactionFunctionalTest
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri("http://localhost:7474");

    @Test
    public void begin__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        long startOfTest = System.currentTimeMillis();
        Thread.sleep(3000L);
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin.location(), TransactionFunctionalTest.matches("http://localhost:\\d+/db/data/transaction/\\d+"));
        long beginStamp = this.expirationTime(JsonHelper.jsonToMap((String)begin.rawContent()));
        long defaultTimeoutMillis = TimeUnit.SECONDS.toMillis(TransactionFunctionalTest.server().getConfiguration().getInt("org.neo4j.server.transaction.timeout", 60));
        Assert.assertTrue((beginStamp > defaultTimeoutMillis + startOfTest ? 1 : 0) != 0);
        String commitResource = begin.stringFromContent("commit");
        MatcherAssert.assertThat((Object)commitResource, TransactionFunctionalTest.matches("http://localhost:\\d+/db/data/transaction/\\d+/commit"));
        Thread.sleep(3000L);
        HTTP.Response execute = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)execute.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        long executeStamp = this.expirationTime(JsonHelper.jsonToMap((String)execute.rawContent()));
        Assert.assertTrue((executeStamp > startOfTest ? 1 : 0) != 0);
        Assert.assertTrue((executeStamp > beginStamp ? 1 : 0) != 0);
        HTTP.Response commit = this.http.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__execute__rollback() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin.location(), TransactionFunctionalTest.matches("http://localhost:\\d+/db/data/transaction/\\d+"));
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        HTTP.Response commit = this.http.DELETE(begin.location());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__execute_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)begin.location(), (Matcher)CoreMatchers.containsString((String)"/db/data/transaction"));
        String commitResource = begin.stringFromContent("commit");
        MatcherAssert.assertThat((Object)commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
        HTTP.Response commit = this.http.POST(commitResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.assertNoErrors((Map)commit.content());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin_and_execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.http.POST(commitResource);
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__execute__commit__execute() throws Exception {
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        String commitResource = begin.stringFromContent("commit");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.http.POST(commitResource);
        HTTP.Response execute = this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)execute.status(), (Matcher)CoreMatchers.equalTo((Object)404));
        this.assertErrorCodes(execute, StatusCode.INVALID_TRANSACTION_ID);
    }

    @Test
    public void begin_and_execute_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    @Test
    public void begin__execute_multiple__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        String commitResource = begin.stringFromContent("commit");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' }, { 'statement': 'CREATE n' } ] }"));
        this.assertNoErrors(this.http.POST(commitResource));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 2L)));
    }

    @Test
    public void begin__execute__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        String commitResource = begin.stringFromContent("commit");
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.http.POST(begin.location(), HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        this.http.POST(commitResource);
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 2L)));
    }

    @Test
    public void begin__commit_with_invalid_cypher() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = HTTP.POST(this.getDataUri() + "transaction", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        String commitResource = response.stringFromContent("commit");
        response = HTTP.POST(commitResource, HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE ;;' } ] }"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        this.assertErrorCodes(response, StatusCode.STATEMENT_SYNTAX_ERROR);
        this.assertErrorMessages(response, "expected an expression that is a node\n\"CREATE ;;\"\n        ^");
        this.assertNoStackTrace(response);
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin__commit_with_malformed_json() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = HTTP.POST(this.getDataUri() + "transaction", HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': 'CREATE n' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response response = HTTP.POST(commitResource, HTTP.RawPayload.rawPayload("[{asd,::}]"));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)200));
        this.assertErrorCodes(response, StatusCode.INVALID_REQUEST_FORMAT);
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)nodesInDatabaseBeforeTransaction));
    }

    @Test
    public void begin_create_two_nodes_delete_one() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.http.POST("/db/data/transaction/commit", HTTP.RawPayload.rawPayload("{ \"statements\" : [{\"statement\" : \"CREATE (n0:DecibelEntity :AlbumGroup{DecibelID : '34a2201b-f4a9-420f-87ae-00a9c691cc5c', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', OriginalReleaseDate : '2013-01-08', IsCanon : 'False'}) return id(n0)\"}, {\"statement\" : \"CREATE (n1:DecibelEntity :AlbumRelease{DecibelID : '9ed529fa-7c19-11e2-be78-bcaec5bea3c3', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', LabelName : 'Barsuk Records', FormatNames : 'File', TrackCount : '3', MediaCount : '1', Duration : '460.000000', ReleaseDate : '2013-01-08', ReleaseYear : '2013', ReleaseRegion : 'USA', Cline : 'Barsuk Records', Pline : 'Barsuk Records', CYear : '2013', PYear : '2013', ParentalAdvisory : 'False', IsLimitedEdition : 'False'}) return id(n1)\"}]}"));
        Assert.assertEquals((long)200L, (long)response.status());
        Map everything = JsonHelper.jsonToMap((String)response.rawContent());
        Map result = (Map)((List)everything.get("results")).get(0);
        long id = ((Number)((List)((List)result.get("data")).get(0)).get(0)).longValue();
        this.http.POST("/db/data/cypher", HTTP.RawPayload.rawPayload("{\"query\":\"start n = node(" + id + ") delete n\"}"));
        MatcherAssert.assertThat((Object)this.countNodes(), (Matcher)CoreMatchers.equalTo((Object)(nodesInDatabaseBeforeTransaction + 1L)));
    }

    private void assertNoErrors(HTTP.Response response) {
        this.assertErrorCodes((Map)response.content(), new StatusCode[0]);
    }

    private void assertNoErrors(Map<String, Object> response) {
        this.assertErrorCodes(response, new StatusCode[0]);
    }

    private void assertNoStackTrace(HTTP.Response response) {
        Map content = (Map)response.content();
        List errors = (List)content.get("errors");
        for (Map error : errors) {
            Assert.assertFalse((boolean)error.containsKey("stackTrace"));
        }
    }

    private void assertErrorCodes(HTTP.Response response, StatusCode ... expectedErrors) {
        this.assertErrorCodes((Map)response.content(), expectedErrors);
    }

    private void assertErrorMessages(HTTP.Response response, String ... expectedMessages) {
        this.assertErrorMessages((Map)response.content(), expectedMessages);
    }

    private void assertErrorCodes(Map<String, Object> response, StatusCode ... expectedErrors) {
        Iterator errors = ((List)response.get("errors")).iterator();
        Iterator expected = IteratorUtil.iterator((Object[])expectedErrors);
        while (expected.hasNext()) {
            Assert.assertTrue((boolean)errors.hasNext());
            MatcherAssert.assertThat((Object)((Integer)((Map)errors.next()).get("code")), (Matcher)CoreMatchers.equalTo((Object)((StatusCode)expected.next()).getCode()));
        }
        if (errors.hasNext()) {
            Map error = (Map)errors.next();
            Assert.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
        }
    }

    private void assertErrorMessages(Map<String, Object> response, String ... expectedMessages) {
        Iterator errors = ((List)response.get("errors")).iterator();
        Iterator expected = IteratorUtil.iterator((Object[])expectedMessages);
        while (expected.hasNext()) {
            Assert.assertTrue((boolean)errors.hasNext());
            MatcherAssert.assertThat((Object)((String)((Map)errors.next()).get("message")), (Matcher)CoreMatchers.equalTo(expected.next()));
        }
        if (errors.hasNext()) {
            Map error = (Map)errors.next();
            Assert.fail((String)("Expected no more errors, but got " + error.get("message") + " - '" + error.get("message") + "'."));
        }
    }

    private long countNodes() {
        long count = 0L;
        Iterator allNodes = GlobalGraphOperations.at((GraphDatabaseService)this.graphdb()).getAllNodes().iterator();
        while (allNodes.hasNext()) {
            allNodes.next();
            ++count;
        }
        return count;
    }

    private static Matcher<String> matches(final String pattern) {
        final Pattern regex = Pattern.compile(pattern);
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                return regex.matcher(item).matches();
            }

            public void describeTo(Description description) {
                description.appendText("matching regex").appendValue((Object)pattern);
            }
        };
    }

    private long expirationTime(Map<String, Object> entity) throws ParseException {
        String timestampString = (String)((Map)entity.get("transaction")).get("expires");
        return RFC1123.parseTimestamp((String)timestampString).getTime();
    }
}

