/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.web.CollectUserAgentFilter;

public class UserAgentCollectorDocIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(UserAgentCollectorDocIT.server());
    }

    @Test
    public void shouldRecordUserAgent() throws Exception {
        this.sendRequest("test/1.0");
        MatcherAssert.assertThat((Object)CollectUserAgentFilter.getUserAgents(), (Matcher)CoreMatchers.hasItem((Object)"test/1.0"));
        CollectUserAgentFilter.reset();
        MatcherAssert.assertThat((Object)CollectUserAgentFilter.getUserAgents().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldRecordUserAgentWithSpaces() throws Exception {
        this.sendRequest("test/1.0 fuss");
        MatcherAssert.assertThat((Object)CollectUserAgentFilter.getUserAgents(), (Matcher)CoreMatchers.hasItem((Object)"test/1.0"));
    }

    @Test
    public void shouldRecordMultipleUserAgentWithSpaces() throws Exception {
        this.sendRequest("test/1.0 fuss");
        this.sendRequest("foo/2.0 bar");
        MatcherAssert.assertThat((Object)CollectUserAgentFilter.getUserAgents(), (Matcher)Matchers.hasItems((Object[])new String[]{"test/1.0", "foo/2.0"}));
    }

    private void sendRequest(String userAgent) {
        for (int i = 0; i < 100; ++i) {
            String url = functionalTestHelper.baseUri().toString();
            JaxRsResponse resp = RestRequest.req().header("User-Agent", userAgent).get(url);
            String json = resp.getEntity();
            resp.close();
            Assert.assertEquals((String)json, (long)200L, (long)resp.getStatus());
        }
    }
}

