/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.security.KeyStoreFactory;
import org.neo4j.server.security.KeyStoreInformation;
import org.neo4j.server.security.SslCertificateFactory;

public class TestKeyStoreFactory {
    private File cPath;
    private File pkPath;
    private File keyStorePath;

    @Test
    public void shouldCreateKeyStoreForGivenKeyPair() throws Exception {
        SslCertificateFactory ssl = new SslCertificateFactory();
        ssl.createSelfSignedCertificate(this.cPath, this.pkPath, "asd");
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        KeyStoreInformation ks = keyStoreFactory.createKeyStore(this.keyStorePath, this.pkPath, this.cPath);
        File keyStoreFile = new File(ks.getKeyStorePath());
        Assert.assertThat((Object)keyStoreFile.exists(), (Matcher)Matchers.is((Object)true));
        this.keyStorePath.delete();
    }

    @Before
    public void createFiles() throws IOException {
        this.cPath = File.createTempFile("cert", "test");
        this.pkPath = File.createTempFile("privatekey", "test");
        this.keyStorePath = File.createTempFile("keyStore", "test");
    }

    @After
    public void deleteFiles() {
        this.keyStorePath.delete();
        this.pkPath.delete();
        this.cPath.delete();
    }
}

