/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.Arrays;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.WrappingNeoServer;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.logging.InMemoryAppender;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.Mute;
import org.neo4j.test.TestGraphDatabaseFactory;

@Path(value="/")
public class TestJetty6WebServer {
    @Rule
    public Mute mute = Mute.muteAll();

    @GET
    public Response index() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        AbstractGraphDatabase db = (AbstractGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
        WrappingNeoServer neoServer = new WrappingNeoServer((GraphDatabaseAPI)db);
        WebServer server = neoServer.getWebServer();
        try {
            server.setAddress("127.0.0.1");
            server.setPort(7878);
            server.addJAXRSPackages(Arrays.asList("org.neo4j.server.web"), "/", null);
            server.start();
            server.stop();
            server.start();
        }
        finally {
            try {
                server.stop();
            }
            catch (Throwable t) {}
            db.shutdown();
        }
    }

    @Test
    public void shouldBeAbleToSetExecutionLimit() throws Throwable {
        InMemoryAppender appender = new InMemoryAppender(AbstractNeoServer.log);
        final Guard dummyGuard = new Guard(StringLogger.DEV_NULL);
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(){

            public Guard getGuard() {
                return dummyGuard;
            }
        };
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)db);
        config.configuration().setProperty("org.neo4j.server.webserver.port", (Object)7476);
        config.configuration().setProperty("org.neo4j.server.webserver.limit.executiontime", (Object)1000);
        WrappingNeoServerBootstrapper testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)config);
        testBootstrapper.start();
        Assert.assertThat((Object)appender.toString(), (Matcher)Matchers.containsString((String)"Server started on"));
        testBootstrapper.stop();
    }
}

